/**
 * 
 */
package dreiecksrechner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/**
 * View-Klasse, die zusammen mit der DreiecksPanel-Klasse die Benutzeroberflaeche des Dreiecksrechners bildet
 */
public class DreiecksrechnerView extends JFrame {

	/*
	 * Hier nicht notwendig. Eingefuegt, um Warnmeldung der Entwicklungsumgebung zu vermeiden.
	 * Alternative: Deaktivieren der Warnmeldung
	 */
	private static final long serialVersionUID = 1L;

	// Instanzvariablen
	private DreiecksrechnerController dController;
	private Image logo;
	private Font font;
	private TitledBorder eBorder;
	private TitledBorder aBorder;
	private String logoPath 			= "images/logo.jpg";
	private DreiecksPanel dPanel 		= new DreiecksPanel();
	private JPanel eaPanel 				= new JPanel();
	private JPanel ePanel 				= new JPanel();
	private JPanel aPanel 				= new JPanel();
	private JPanel logoPanel 			= new JPanel();
	private JButton berechnenButton 	= new JButton("Berechnen");
	private JLabel hypothenuse 			= new JLabel("Hypothenuse:");
	private JLabel winkelAlpha 			= new JLabel("Winkel Alpha:");
	private JLabel winkelBeta 			= new JLabel("Winkel Beta:");
	private JTextField hypothenuseTF 	= new JTextField();
	private JTextField winkelAlphaTF 	= new JTextField();
	private JTextField winkelBetaTF 	= new JTextField();
	private JLabel leererJLabel 		= new JLabel("");
	private JLabel logoLabel 			= new JLabel();

	// Konstruktor
	public DreiecksrechnerView(DreiecksrechnerController dController) {

		super("Dreiecksrechner für rechtwinklige Dreiecke");
		this.dController = dController;

		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		// Größe für JFrame setzen
		this.setSize(800, 800);
		// Hintergundfarben setzen
		this.setzeHintergrundfarben();
		// Layout für JFrame festlegen
		BorderLayout bdl = new BorderLayout();
		this.setLayout(bdl);
		this.add(dPanel, BorderLayout.NORTH);
		this.add(eaPanel, BorderLayout.CENTER);
		this.add(logoPanel, BorderLayout.SOUTH);
		// Layout für eaPanel festlegen
		GridLayout eaGl = new GridLayout(2,1);
		eaPanel.setLayout(eaGl);
		eaPanel.add(ePanel);
		eaPanel.add(aPanel);
		// Rahmen für ePanel
		eBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Eingabe");
		ePanel.setBorder(eBorder);
		// Layout für ePanel festlegen
		GridLayout eGl = new GridLayout(2,2,20,20);
		ePanel.setLayout(eGl);
		ePanel.add(hypothenuse);
		ePanel.add(hypothenuseTF);
		ePanel.add(winkelAlpha);
		ePanel.add(winkelAlphaTF);	
		// Rahmen für aPanel
		aBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.white), "Ausgabe");
		aPanel.setBorder(aBorder);   
		// Layout für aPanel festlegen
		GridLayout aGl = new GridLayout(2,2,20,20);
		aPanel.setLayout(aGl);
		aPanel.add(winkelBeta);
		aPanel.add(winkelBetaTF);
		aPanel.add(berechnenButton);
		//Leerer JLabel wird nur eingefügt, damit die Anordnung korrekt ist.
		aPanel.add(leererJLabel);
	
		//Schriften setzen
		this.setzeFonts();

		if (this.liesImageEin(logoPath)!=null) {
			//Logo einlesen und als Icon zu JLabel hinzufügen
			logo = this.liesImageEin(logoPath);
			Icon logoIcon = new ImageIcon(logo);
			logoLabel.setIcon(logoIcon);
			//Zu logoPanel hinzufügen
			logoPanel.add(logoLabel);
		}

		// Hauptfenster anzeigen
		this.setVisible(true);

		// Actionlistener registrieren
		berechnenButton.addActionListener(e -> berechneUndZeigeErgebnisse(hypothenuseTF.getText(), winkelAlphaTF.getText()));		
	}

	public void berechneUndZeigeErgebnisse(String hypothenuse, String winkelAlpha) {
		int wAlpha = Integer.parseInt(winkelAlpha);
		this.winkelBetaTF.setText(Integer.toString(dController.berechneWinkelBeta(wAlpha)));
	}

	public Image liesImageEin(String imagePfad) {
		return dController.liesBildEin(imagePfad);
	}

	public void setzeFonts() {
		font = new Font(Font.SANS_SERIF, Font.PLAIN, 20);
		this.hypothenuse.setFont(font);
		this.hypothenuse.setForeground(Color.white);
		this.winkelAlpha.setFont(font);
		this.winkelAlpha.setForeground(Color.white);
		this.winkelBeta.setFont(font);
		this.winkelBeta.setForeground(Color.white);
		this.hypothenuseTF.setFont(font);
		this.winkelAlphaTF.setFont(font);
		this.winkelBetaTF.setFont(font);
		this.logoLabel.setFont(font);
		this.eBorder.setTitleFont(font);
		this.eBorder.setTitleColor(Color.gray);
		this.aBorder.setTitleFont(font);
		this.aBorder.setTitleColor(Color.gray);
		this.berechnenButton.setFont(font);
	}

	public void setzeHintergrundfarben() {
		this.setBackground(Color.black);
		dPanel.setBackground(Color.black);
		eaPanel.setBackground(Color.black);
		logoPanel.setBackground(Color.black);
		ePanel.setBackground(Color.black);
		aPanel.setBackground(Color.black);
	}
}
